/*
 * Decompiled with CFR 0.152.
 */
package org.gvagroup.pool;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import org.gvagroup.pool.ConnectionPoolEntry;

public class ConnectionInfo
implements Serializable,
Comparable<ConnectionInfo> {
    private static final long serialVersionUID = 1042655755512239102L;
    private final int _id;
    private final long _lastThreadID;
    private final String _type;
    private final boolean _isDynamic;
    private final boolean _isConnected;
    private final boolean _inUse;
    private final int _connectCount;
    private final int _checkCount;
    private final long _useCount;
    private final long _sessionUseCount;
    private final Duration _totalUse;
    private final Duration _currentUse;
    private final Duration _maxUse;
    private final Instant _lastUsed;
    private final Instant _lastChecked;
    private final Throwable _trace;

    ConnectionInfo(ConnectionPoolEntry<?> entry) {
        this._id = entry.getID();
        this._lastThreadID = entry.getLastThreadID();
        this._type = entry.getType();
        this._isDynamic = entry.isDynamic();
        this._isConnected = entry.isConnected();
        this._inUse = entry.inUse();
        this._useCount = entry.getUseCount();
        this._checkCount = entry.getCheckCount();
        this._connectCount = entry.getConnectCount();
        this._sessionUseCount = entry.getSessionUseCount();
        this._totalUse = entry.getTotalUseTime();
        this._currentUse = Duration.ofNanos(entry.getUseTime());
        this._maxUse = entry.getMaxUseTime();
        this._trace = entry.getStackInfo();
        this._lastUsed = entry.getLastUseTime() > 0L ? Instant.ofEpochMilli(entry.getLastUseTime()) : null;
        this._lastChecked = entry.getLastCheckTime() > 0L ? Instant.ofEpochMilli(entry.getLastCheckTime()) : null;
    }

    public int getID() {
        return this._id;
    }

    public String getType() {
        return this._type;
    }

    public Throwable getStackInfo() {
        return this._trace;
    }

    public long getLastThreadID() {
        return this._lastThreadID;
    }

    public boolean getInUse() {
        return this._inUse;
    }

    public boolean getConnected() {
        return this._isConnected;
    }

    public boolean getDynamic() {
        return this._isDynamic;
    }

    public int getConnectCount() {
        return this._connectCount;
    }

    public long getUseCount() {
        return this._useCount;
    }

    public long getSessionUseCount() {
        return this._sessionUseCount;
    }

    public int getCheckCount() {
        return this._checkCount;
    }

    public Duration getTotalUse() {
        return this._totalUse;
    }

    public Duration getAvgUse() {
        return this._useCount == 0L ? Duration.ZERO : Duration.ofNanos(this._totalUse.toNanos() / this._useCount);
    }

    public Duration getCurrentUse() {
        return this._currentUse;
    }

    public Duration getMaxUse() {
        return this._maxUse;
    }

    public Instant getLastUsed() {
        return this._lastUsed;
    }

    public Instant getLastChecked() {
        return this._lastChecked;
    }

    public String getTypeName() {
        return this._isDynamic ? "Dynamic" : "Persistent";
    }

    @Override
    public int compareTo(ConnectionInfo ci2) {
        int tmpResult = Integer.compare(this._id, ci2._id);
        return tmpResult == 0 ? Long.compare(this._useCount, ci2._useCount) : tmpResult;
    }

    public int hashCode() {
        return this._id;
    }
}

