/*
 * Decompiled with CFR 0.152.
 */
package org.gvagroup.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.gvagroup.common.SystemEvent;

public class EventDispatcher {
    private static final Map<Thread, Queue<SystemEvent>> _events = new HashMap<Thread, Queue<SystemEvent>>();

    private EventDispatcher() {
    }

    public static synchronized void waitForEvent() throws InterruptedException {
        if (!_events.containsKey(Thread.currentThread())) {
            _events.put(Thread.currentThread(), new ConcurrentLinkedQueue());
        }
        EventDispatcher.class.wait();
    }

    public static synchronized void send(SystemEvent e) {
        Iterator<Map.Entry<Thread, Queue<SystemEvent>>> i = _events.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Thread, Queue<SystemEvent>> me = i.next();
            if (me.getKey().isAlive()) {
                me.getValue().add(e);
                continue;
            }
            i.remove();
        }
        EventDispatcher.class.notifyAll();
    }

    public static synchronized Collection<SystemEvent> getEvents() {
        Queue<SystemEvent> events = _events.get(Thread.currentThread());
        if (events == null) {
            return Collections.emptySet();
        }
        ArrayList<SystemEvent> results = new ArrayList<SystemEvent>(events);
        events.clear();
        return results;
    }

    public static synchronized void unregister() {
        _events.remove(Thread.currentThread());
    }

    public static synchronized void shutDown() {
        Iterator<Map.Entry<Thread, Queue<SystemEvent>>> i = _events.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Thread, Queue<SystemEvent>> me = i.next();
            if (me.getKey().isAlive()) {
                me.getKey().interrupt();
            }
            me.getValue().clear();
            i.remove();
        }
    }
}

